<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class PropertyGroupLanguage extends Model 
{

    protected $table = 'lim_property_group_languages';
    public $timestamps = true;
    protected $fillable = array('lim_language_id', 'lim_property_group_id', 'name', 'content');
    protected $visible = array('lim_language_id', 'lim_property_group_id', 'name', 'content');

    public function language()
    {
        return $this->belongsTo('App\Models\Language', 'lim_language_id');
    }

    public function propertyGroup()
    {
        return $this->belongsTo('App\Model\PropertyGroup', 'lim_property_group_id');
    }

}